''=============================================================================
''  
''    Version 0.6
''    Easy GL2D (FB.IMAGE compatible version)
''    By Relminator (Richard Eric M. Lope)
''    http://rel.betterwebber.com
''    
''    An easy to use OpenGL 2d lib
''    As easy as fbgfx (easier IMHO if you use my Texture packer)
''    
''    Can automatically load BMP's supported by BLOAD
''    Adds alpha transparency if you want
''    No external dependencies (only uses OpenGL/GLU and FBGFX)
''    Source license is "use or abuse"
''
''=============================================================================


#pragma once

'' include needed libs
#include once "fbgfx.bi"
#include once "gl/gl.bi" 
#include once "gl/glu.bi"   


'' safety
namespace GL2D

'' enums for blending options
enum E_BLEND_MODE

	E_TRANS = 0,
	E_SOLID,
	E_BLENDED,
	E_GLOW,
	E_BLACK

end enum

enum E_FLIP_MODE

	E_NONE = 0,
	E_V,
	E_H,
	E_VH
	
end enum

''=============================================================================
''
''    Some helpful macros for FB.IMAGE type
''    For GL2D primitives that accepts color(GLuint)
''    Use GL2D_RGBA( r, g, b, a ) as FB is and GL are reversed endians
''
''=============================================================================	
#define ARGB_A(u) (((u) shr 24) and &H000000FF)
#define ARGB_R(u) (((u) shr 16) and &H000000FF)
#define ARGB_G(u) (((u) shr 8)  and &H000000FF)
#define ARGB_B(u) (((u) shr 0)  and &H000000FF)
#define ARGB( r, g, b, a )   rgba( (b), (g), (r), (a) )
#define GL2D_RGBA( r, g, b, a )   rgba( (b), (g), (r), (a) )



''=============================================================================
''
''    Our sprite datatype (Uses the FB.IMAGE struct)
''
''=============================================================================
type _OLD_HEADER field = 1
	bpp : 3 as ushort
	width : 13 as ushort
	height as ushort
end type


type IMAGE field = 1

	union
		old 		as _OLD_HEADER
		type 		as uinteger
	end union
	bpp 			as integer
	width 			as uinteger
	height 			as uinteger
	pitch 			as uinteger
	
	'' _reserved(1 to 12) as ubyte
	'' 12 bytes are used to be compatible 

	textureID 		as uinteger			'' 4 bytes
	u_offset		as ushort			'' 2 bytes
	v_offset		as ushort			'' 2 bytes
	texture_width	as ushort			'' 2 bytes
	texture_height	as ushort			'' 2 bytes

end type


declare sub vsync_on()

declare sub start_2d(byval wid as integer, byval hei as integer)

declare sub end_2d()  

declare sub screen_init(byval screen_wid as integer, byval screen_hei as integer, byval flags as integer = 0)

declare sub set_blend_mode(byval blend_mode as E_BLEND_MODE)

declare sub enable_sprite_stencil( byval flag as integer = 0,_
						   byval gl2dcolor as GLuint = GL2D_RGBA(0,0,0,0),_
						   byval gl2dcolor_env as GLuint = GL2D_RGBA(0,0,0,0)  )
	
declare sub enable_antialias(byval switch as integer = 1)

declare sub clear_screen()

declare sub put_pixel( byval x as integer, byval y as integer, byval gl2dcolor as GLuint )

declare sub line_2d( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer, byval gl2dcolor as GLuint )

declare sub box( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer, byval gl2dcolor as GLuint )

declare sub box_filled( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer, byval gl2dcolor as GLuint )

declare sub box_filled_gradient( byval x1 as integer, byval y1 as integer,_
						 byval x2 as integer, byval y2 as integer,_
						 byval gl2dcolor1 as GLuint,_
						 byval gl2dcolor2 as GLuint,_
						 byval gl2dcolor3 as GLuint,_
						 byval gl2dcolor4 as GLuint )

declare sub triangle( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer,_
			  byval x3 as integer, byval y3 as integer, byval gl2dcolor as GLuint )

declare sub triangle_filled( byval x1 as integer, byval y1 as integer, byval x2 as integer, byval y2 as integer,_
			         byval x3 as integer, byval y3 as integer, byval gl2dcolor as GLuint )

declare sub triangle_filled_gradient( byval x1 as integer, byval y1 as integer,_ 
							  byval x2 as integer, byval y2 as integer,_
			                  byval x3 as integer, byval y3 as integer,_
			                  byval gl2dcolor1 as GLuint, byval gl2dcolor2 as GLuint, byval gl2dcolor3 as GLuint )

declare sub circle_2d(byval x as integer, byval y as integer, byval radius as integer, byval gl2dcolor as GLuint)

declare sub circle_2d_filled(byval x as integer, byval y as integer, byval radius as integer, byval gl2dcolor as GLuint )

declare sub ellipse(byval x as single, byval y as single, byval a as single, byval b as single, byval angle as single, byval gl2dcolor as GLuint )

declare sub ellipse_filled(byval x as single, byval y as single, byval a as single, byval b as single, byval angle as single, byval gl2dcolor as GLuint )

declare sub sprite( byval x as integer, byval y as integer, byval spr as image ptr)

declare sub sprite_flip( byval x as integer, byval y as integer, byval mode as E_FLIP_MODE, byval spr as image ptr)

declare sub sprite_scale( byval x as integer, byval y as integer, byval scale as single, byval spr as image ptr)

declare sub sprite_rotate( byval x as integer, byval y as integer, byval angle as integer, byval spr as image ptr)

declare sub sprite_rotate_scale( byval x as integer, byval y as integer, byval angle as integer, byval scale as single, byval spr as image ptr)

declare sub sprite_stretch( byval x1 as integer, byval y1 as integer,_
					byval x2 as integer, byval y2 as integer,_
					byval spr as image ptr)

declare sub sprite_stretch_on_quad( byval x1 as integer, byval y1 as integer,_
							byval x2 as integer, byval y2 as integer,_
							byval x3 as integer, byval y3 as integer,_
							byval x4 as integer, byval y4 as integer,_
							byval spr as image ptr)

declare sub sprite_stretch_h( byval x as integer, byval y as integer, byval length as integer, byval spr as image ptr )

declare sub line_glow ( byval x1 as single, byval y1 as single, byval x2 as single, byval y2 as single,_
				byval lwidth as single, byval mycolor as GLuint, byval spr as image ptr = 0 )

declare sub print_scale(byval x as integer, byval y as integer,byval scale as single, byref text as const string)

declare function load_image( byval spr as any ptr, byval filter_mode as GLuint = GL_NEAREST ) as GLuint

declare function load_image_24bit_alpha( byval spr as any ptr, byval filter_mode as GLuint = GL_NEAREST ) as GLuint

declare function load_image_8bit_alpha( byval spr as any ptr, byval filter_mode as GLuint = GL_NEAREST ) as GLuint

declare function load_BMP_to_texture(byref filename as string) as GLuint

declare function load_BMP_to_glsprite(byref filename as string, byval filter_mode as GLuint = GL_NEAREST ) as IMAGE ptr

declare sub load_image_to_HW(byval spr as image ptr, byval filter_mode as GLuint = GL_NEAREST )

declare sub init_sprites overload(spriteset() as IMAGE ptr, texcoords() as uinteger,_
				 byref filename as string, byval filter_mode as GLuint = GL_NEAREST )

declare sub init_sprites overload(spriteset() as IMAGE ptr, byval tile_wid as integer, byval tile_hei as integer, byref filename as string, byval filter_mode as GLuint = GL_NEAREST )

declare sub destroy_sprites(spriteset() as IMAGE ptr)

declare sub destroy()

declare sub destroy_image(byval spr as IMAGE ptr)

declare function fps_limit(byval max_FPS as single) as single


end namespace



